function lidar_proc=read_Vad(fid)
status=fseek(fid,0,'eof')
filesize=ftell(fid)
status=fseek(fid,0,'bof')
%Filename
C=textscan(fid,'%s %s %s',1);
lidar_proc.orig_filename=[char(C{1,2}),' ',char(C{1,3})];
%StartTime
C=textscan(fid,'%s %s %s %s',1);
temp=[char(C{1,3}),' ',char(C{1,4})];
lidar_proc.start_time=datenum(char(temp),'yyyy-mm-dd HH:MM:SS');
%Measurement ID
C=textscan(fid,'%s %s %s',1);
lidar_proc.system_id=C{1,3};
%Rays in scan
C=textscan(fid,'%s %s %s %d',1);
lidar_proc.rays_in_scan=C{1,4};
%#ofgates
C=textscan(fid,'%s %s %s %d',1);
lidar_proc.number_of_gates=C{1,4};
%gate length
C=textscan(fid,'%s %s %s %n',1);
lidar_proc.range_gate_length=C{1,4};
%Gate Overlapping
C=textscan(fid,'%s %s %s',1);
lidar_proc.gate_overlap=C{1,3};
%GPS
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s',1);
lidar_proc.GPS=[char(C{1,2}),' ',char(C{1,3}),' ',char(C{1,4}),' ',...
    char(C{1,5}),' ',char(C{1,6}),' ',char(C{1,7}),' ',...
    char(C{1,8}),' ',char(C{1,9}),' ',char(C{1,10}),' ',char(C{1,11})];
%Voltage
C=textscan(fid,'%s %s %n',1);
lidar_proc.input_voltage=C{1,3};
%Temperature
C=textscan(fid,'%s %s %n',1);
lidar_proc.internal_temperature=C{1,3};
%Humidity
C=textscan(fid,'%s %s %n',1);
lidar_proc.internal_humidity=C{1,3};

lidar_proc.ranges=zeros(1,lidar_proc.number_of_gates);
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s',1);
j=1;
for j=1:lidar_proc.rays_in_scan
    for k=1:lidar_proc.number_of_gates
        C=textscan(fid,'%n %n %n %s %n %n %s',1);
        if j==1
        lidar_proc.ranges(k)=C{1,1};
        end
        lidar_proc.RWS(j,k)=C{1,2};
        lidar_proc.SNR(j,k)=C{1,3};
        kk=datevec(char(C{1,4}),'hh:mm:ss');

        lidar_proc.ray_time(j,k)=kk(4)+((kk(5)+kk(6)/60))/60;
        lidar_proc.azimuth(j)=C{1,5};
        lidar_proc.elevation(j)=C{1,6};
    end
end
return









